/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.util;

import com.alcatrazescapee.alcatrazcore.util.CoreHelpers;
import com.alcatrazescapee.notreepunching.ModConfig;
import com.alcatrazescapee.notreepunching.NoTreePunching;
import com.alcatrazescapee.notreepunching.common.items.ItemKnife;
import com.alcatrazescapee.notreepunching.common.items.ItemRock;
import com.alcatrazescapee.notreepunching.common.items.ModItems;
import com.alcatrazescapee.notreepunching.util.Util;
import com.alcatrazescapee.notreepunching.util.types.Stone;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class HarvestBlockHandler {
    private static final Set<Predicate<IBlockState>> EXCEPTIONS = new HashSet<Predicate<IBlockState>>();
    private static final List<ItemStack> GRASS_DROPS = new ArrayList<ItemStack>();

    public static void postInit() {
        HarvestBlockHandler.reloadWhitelist();
        HarvestBlockHandler.addGrassDrop(new ItemStack(ModItems.GRASS_FIBER));
        HarvestBlockHandler.addGrassDrop(new ItemStack(ModItems.GRASS_FIBER, 2));
    }

    public static void reloadWhitelist() {
        EXCEPTIONS.clear();
        for (String s : ModConfig.GENERAL.alwaysBreakable) {
            try {
                EXCEPTIONS.add(HarvestBlockHandler.createPredicate(s));
            }
            catch (IllegalArgumentException e) {
                NoTreePunching.getLog().warn("Problem loading entry in alwaysBreakable: {}, {}", (Object)s, (Object)e);
            }
        }
        EXCEPTIONS.removeIf(Objects::isNull);
    }

    public static void addExtraDrops(List<ItemStack> drops, IBlockState state, EntityPlayer player, ItemStack stack, boolean isSilkTouch) {
        Stone stone = Stone.getFromBlock(state);
        if (stone != null && stone.isEnabled() && ModConfig.GENERAL.enableStoneDropChanges && !isSilkTouch) {
            drops.clear();
            drops.add(new ItemStack((Item)ItemRock.get(stone), 2 + Util.RNG.nextInt(3)));
        }
        if (state.func_177230_c() instanceof BlockLeaves && !isSilkTouch) {
            float stickChance = (float)ModConfig.BALANCE.leavesStickDropChance;
            if (CoreHelpers.doesStackMatchOre((ItemStack)stack, (String)"toolKnife")) {
                stickChance += 0.3f;
            }
            if (Util.RNG.nextFloat() < stickChance) {
                drops.add(new ItemStack(Items.field_151055_y, 1 + Util.RNG.nextInt(1)));
            }
        }
        if ((state.func_177230_c() instanceof BlockTallGrass || state.func_177230_c() instanceof BlockDoublePlant && (state.func_177229_b((IProperty)BlockDoublePlant.field_176493_a) == BlockDoublePlant.EnumPlantType.FERN || state.func_177229_b((IProperty)BlockDoublePlant.field_176493_a) == BlockDoublePlant.EnumPlantType.GRASS)) && stack.func_77973_b() instanceof ItemKnife) {
            if ((double)Util.RNG.nextFloat() < ModConfig.BALANCE.tallGrassDropPlantFiberChance) {
                ItemStack drop = GRASS_DROPS.get(Util.RNG.nextInt(GRASS_DROPS.size()));
                drops.add(drop.func_77946_l());
            }
            stack.func_77972_a(1, (EntityLivingBase)player);
            player.func_184611_a(EnumHand.MAIN_HAND, stack);
        }
    }

    public static boolean isInvalidTool(@Nullable ItemStack stack, @Nullable EntityPlayer player, IBlockState state) {
        if (player == null || stack == null) {
            return true;
        }
        if (HarvestBlockHandler.isWhitelisted(state)) {
            return false;
        }
        int neededHarvestLevel = state.func_177230_c().getHarvestLevel(state);
        String neededToolClass = state.func_177230_c().getHarvestTool(state);
        if (neededToolClass != null) {
            if (stack.func_190926_b()) {
                return true;
            }
            for (String toolClass : stack.func_77973_b().getToolClasses(stack)) {
                if (neededToolClass.equals(toolClass) && stack.func_77973_b().getHarvestLevel(stack, toolClass, player, state) >= neededHarvestLevel) {
                    return false;
                }
                if (neededToolClass.equals("shovel") && toolClass.equals("pickaxe") && stack.func_77973_b().getHarvestLevel(stack, toolClass, player, state) >= 1) {
                    return false;
                }
                if (!toolClass.equals("mattock") || !neededToolClass.equals("axe") && !neededToolClass.equals("shovel")) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static float getSpeedModifier(String toolClass) {
        switch (toolClass) {
            case "axe": 
            case "mattock": {
                return 0.2f;
            }
            case "pickaxe": {
                return 0.125f;
            }
        }
        return 0.33f;
    }

    public static boolean isWhitelisted(IBlockState state) {
        return EXCEPTIONS.stream().anyMatch(x -> x.test(state));
    }

    public static void addGrassDrop(ItemStack stack) {
        GRASS_DROPS.add(stack);
    }

    private static Predicate<IBlockState> createPredicate(String entry) throws IllegalArgumentException {
        int colon2;
        int colon;
        if (entry.length() >= 9 && entry.substring(0, 9).equals("material:")) {
            try {
                Object obj = ObfuscationReflectionHelper.getPrivateValue(Material.class, null, (String[])new String[]{entry.substring(9).toUpperCase()});
                if (obj instanceof Material) {
                    Material material = (Material)obj;
                    return state -> state.func_185904_a() == material;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Material is incorrect somehow", e);
            }
        }
        if ((colon = entry.indexOf(58)) == (colon2 = entry.lastIndexOf(58))) {
            Block block = Block.func_149684_b((String)entry);
            if (block == null) {
                throw new IllegalArgumentException("Block is null, no metadata");
            }
            return state -> state.func_177230_c() == block;
        }
        Block block = Block.func_149684_b((String)entry.substring(0, colon2));
        if (block == null) {
            throw new IllegalArgumentException("Block is null, with metadata");
        }
        int meta = Integer.valueOf(entry.substring(colon2 + 1));
        return state -> state.func_177230_c() == block && state.func_177230_c().func_176201_c(state) == meta;
    }
}

